package com.hero.objects.powers;

import org.jdom.Element;

import com.hero.HeroDesigner;
import com.hero.objects.Adder;
import com.hero.objects.GenericObject;
import com.hero.objects.modifiers.Modifier;
import com.hero.util.Rounder;

/**
 * Copyright (c) 2000 - 2005, CompNet Design, Inc. All rights reserved.
 * Redistribution and use in source and binary forms, with or without
 * modification, is prohibited unless the following conditions are met: 1.
 * Express written consent of CompNet Design, Inc. is obtained by the developer.
 * 2. Redistributions must retain this copyright notice. THIS SOFTWARE IS
 * PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS'' AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO
 * EVENT SHALL THE COPYRIGHT HOLDERS OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * @author CompNet Design, Inc.
 * @version $Revision$
 */

public class Entangle extends Power {

	private static String xmlID = "ENTANGLE";

	public Entangle(Element root) {
		super(root, Entangle.xmlID);
	}

	@Override
	public String getColumn2Output() {
		String ret = getAlias() + " " + getDamageDisplay();
		if (getName().trim().length() > 0) {
			ret = "<i>" + getName() + ":</i>  " + ret;
		}
		if ((getInput() != null) && (getInput().trim().length() > 0)) {
			ret += ":  " + getInput();
		}
		if (getSelectedOption() != null) {
			ret += " (";
			ret += getSelectedOption().getAlias();

			String adderString = getAdderString();
			if (adderString.trim().length() > 0) {
				ret += "; " + adderString;
			}
			ret += ")";
		} else {
			String adderString = getAdderString();
			if (adderString.trim().length() > 0) {
				ret += " (" + adderString + ")";
			}
		}
		ret += getModifierString();
		if ((getEndUsage() > 0)
				&& (HeroDesigner.getActiveHero() != null)
				&& (GenericObject.findObjectByID(HeroDesigner.getActiveHero()
						.getPowers(), "ENDURANCERESERVE") != null)
				&& (GenericObject.findObjectByID(getAllAssignedModifiers(),
						"ENDRESERVEOREND") == null)
				&& !HeroDesigner.getInstance().getPrefs().useWG()) {
			if (getUseENDReserve()) {
				ret += " (uses END Reserve)";
			} else {
				ret += " (uses Personal END)";
			}
		}
		return ret;
	}

	@Override
	public String getDamageDisplay() {
		if (HeroDesigner.getActiveTemplate().is6E()) {
			String ret = "" + getLevels() + "d6";
			int bod = getLevels();
			int additional = 0;
			int addEff = 0;

			int pd = (int) Rounder.roundDown(getLevels() / getLevelValue());
			int ed = (int) Rounder.roundDown(getLevels() / getLevelValue());
			for (Adder ad : getAssignedAdders()) {
				if (ad.getXMLID().equals("ADDITIONALPD")) {
					pd += ad.getLevels();
					ad.setDisplayInString(false);
				} else if (ad.getXMLID().equals("ADDITIONALED")) {
					ed += ad.getLevels();
					ad.setDisplayInString(false);
				} else if (ad.getXMLID().equals("ADDITIONALBODY")) {
					bod += ad.getLevels();
					additional += ad.getLevels();
					ad.setDisplayInString(false);
				}
			}
			ret = getLevels() + additional + "d6";
			int baseDice = getLevels() + additional;
			additional = 0;

			for (Adder ad : getAssignedAdders()) {
				if (ad.getXMLID().equals("PLUSONEPIP")) {
					ad.setDisplayInString(false);
					ret = baseDice + "d6";
					additional = 1;
					addEff += 1;
				}
				if (ad.getXMLID().equals("PLUSONEHALFDIE")) {
					ad.setDisplayInString(false);
					ret = baseDice + " 1/2d6";
					addEff += 1;
				}
				if (ad.getXMLID().equals("MINUSONEPIP")) {
					ad.setDisplayInString(false);
					ret = "" + (getLevels() + 1);
					ret = baseDice + 1 + "d6";
					additional -= 1;
					addEff += 1;
				}
			}
			if (additional != 0) {
				if (additional > 0) {
					ret += " + ";
				} else {
					ret += " - ";
				}
				ret += "" + additional;
			}

			for (Modifier mod : getAllAssignedModifiers()) {
				if (mod.getXMLID().equals("NODEFENSE")) {
					pd = 0;
					ed = 0;
				}
			}
			ret += ", " + pd + " PD/"+ed+" ED";
			if (useStandardEffect()) {
				ret += " (standard effect: " + (bod + addEff) + " BODY, " + pd + " PD/"+ed+" ED)";
			}
			return ret;
		} else {
			String ret = "" + getLevels() + "d6";
			int bod = getLevels();
			int additional = 0;
			int addEff = 0;

			int def = (int) Rounder.roundDown(getLevels() / getLevelValue());
			for (Adder ad : getAssignedAdders()) {
				if (ad.getXMLID().equals("ADDITIONALDEF")) {
					def += ad.getLevels();
					ad.setDisplayInString(false);
				} else if (ad.getXMLID().equals("ADDITIONALBODY")) {
					bod += ad.getLevels();
					additional += ad.getLevels();
					ad.setDisplayInString(false);
				}
			}
			ret = getLevels() + additional + "d6";
			int baseDice = getLevels() + additional;
			additional = 0;

			for (Adder ad : getAssignedAdders()) {
				if (ad.getXMLID().equals("PLUSONEPIP")) {
					ad.setDisplayInString(false);
					ret = baseDice + "d6";
					additional = 1;
					addEff += 1;
				}
				if (ad.getXMLID().equals("PLUSONEHALFDIE")) {
					ad.setDisplayInString(false);
					ret = baseDice + " 1/2d6";
					addEff += 1;
				}
				if (ad.getXMLID().equals("MINUSONEPIP")) {
					ad.setDisplayInString(false);
					ret = "" + (getLevels() + 1);
					ret = baseDice + 1 + "d6";
					additional -= 1;
					addEff += 1;
				}
			}
			if (additional != 0) {
				if (additional > 0) {
					ret += " + ";
				} else {
					ret += " - ";
				}
				ret += "" + additional;
			}

			for (Modifier mod : getAllAssignedModifiers()) {
				if (mod.getXMLID().equals("NODEFENSE")) {
					def = 0;
				}
			}
			ret += ", " + def + " DEF";
			if (useStandardEffect()) {
				ret += " (standard effect: " + (bod + addEff) + " BODY, " + def
						+ " DEF)";
			}
			return ret;
		}
	}

	@Override
	protected void init(Element root) {
		super.init(root);
		setLevels(getLevels());
	}

	@Override
	public void restoreFromSave(Element root) {
		super.restoreFromSave(root);
		setLevels(getLevels());
	}

	@Override
	public void setLevels(int val) {
		super.setLevels(val);
		Adder bod = (Adder) GenericObject.findObjectByID(availableAdders,
				"ADDITIONALBODY");
		Adder def = (Adder) GenericObject.findObjectByID(availableAdders,
				"ADDITIONALDEF");
		if (bod != null) {
			bod.setMaxLevel(val);
		}
		if (def != null) {
			def.setMaxLevel(val);
		}
		bod = (Adder) GenericObject.findObjectByID(assignedAdders,
				"ADDITIONALBODY");
		def = (Adder) GenericObject.findObjectByID(assignedAdders,
				"ADDITIONALDEF");
		if (bod != null) {
			bod.setMaxLevel(val);
		}
		if (def != null) {
			def.setMaxLevel(val);
		}
	}
}